#!/bin/sh
#
# g2_udev.sh installs and activates udev rules that create symbolic links
# to serial connections in an Anan G2 Software Defined Radio
# CT1IQI, January 2025, version 1.0
# Run g2_udev.sh with superuser rights and execution rights (chmod 755). 
#
version='1.0'
[ "n${1}" = 'n-V' ] && {
  echo 'g2udev.sh v. '"${version}"
  exit
}

rulepath='/etc/udev/rules.d/61-g2-serial.rules'
[ -f "${rulepath}" ] && rm "${rulepath}"

cat > "${rulepath}" << EOF
# this is used to provide serial communication based peripherals
# of an Anan G2 SDR with symbolic device links
# January 2025 CT1IQI
# version 1.0

ACTION=="remove", GOTO="g2_serial_end"
SUBSYSTEM!="tty", GOTO="g2_serial_end"

# kernel must have made it a tty
KERNEL!="ttyUSB[0-9]*|ttyACM[0-9]*|ttyS[0-9]*|ttyAMA[0-9]*", GOTO="g2_serial_end"

# detect G2 with Rpi-CM4 and Mk2 8" control front
# Rpi-CM4 UART3, base register address 0x7e201600, mapped to 0xfe201600
ATTR{iomem_base}=="0xFE201600", SYMLINK+="serial/by-id/g2-front-9600", GOTO="g2_other"

# '1-1.4' is the enumeration of the G2 front mini-USB connector, as found using a Radxa CM5
# G2 Front V2, Radxa CM5 modification with Arduino Nano Every
KERNELS=="1-1.4", ATTRS{idVendor}=="2341", ATTRS{idProduct}=="0058", SYMLINK+="serial/by-id/g2-front-9600", GOTO="g2_other"
# G2 Front V1, Radxa CM5 modification with Waveshare RP2040 Zero
KERNELS=="1-1.4", ATTRS{idVendor}=="2e8a", ATTRS{idProduct}=="0003", SYMLINK+="serial/by-id/g2-front-115200"

LABEL="g2_other"
# Aries Arduino nano 33 IoT
ATTRS{idVendor}=="2341", ATTRS{idProduct}=="8057", SYMLINK+="serial/by-id/aries-atu-115200"
 
LABEL="g2_serial_end"
EOF

udevadm control --reload-rules
udevadm trigger
